/* ********************************************************
* pre2ol - convert all pre tags to ol ones in a page.
* author  : Olivier Meunier
* version : 0.1 - 2005-03-11
*
* license :
* Creative Commons Attribution-NonCommercial-ShareAlike 2.0
* http://creativecommons.org/licenses/by-nc-sa/2.0/
******************************************************** */
function pre2ol()
{
	if (!document.getElementsByTagName) {
		return;
	}
	
	var pre = document.getElementsByTagName('pre');
	
	if (pre.length == 0) {
		return;
	}
	
	var tab = "\u00A0\u00A0\u00A0\u00A0\u00A0";
	
	for (var i=0; i<pre.length; i++)
	{
		var e = pre.item(i);
		
		var c = e.childNodes.item(0);
		var content = c.data;
		
		if (e.childNodes.length == 1 && content)
		{
			i--;
			content = content.replace(/\r\n/g,'\n');
			content = content.replace(/\r/g,'\n');
			content = content.replace(/\t/g,tab);
			content = content.replace(/  /g,'\u00A0 ');
			
			var lines = content.split('\n')
			
			var ol = document.createElement("ol");
			
			if (e.id) {
				ol.id = e.id;
			}
			
			var className = 'pre2ol';
			if (e.className) {
				className += ' '+e.className;
			}
			ol.className = className;
			
			for (var j=0; j<lines.length; j++)
			{
				if (lines[j] == '') { lines[j] = '\u00A0'; }
				
				var li = document.createElement('li');
				var span = document.createElement('span');
				var newText = document.createTextNode(lines[j]);
				span.appendChild(newText);
				li.appendChild(span);
				ol.appendChild(li);
			}
			var p = e.parentNode;
			p.replaceChild(ol,e);
		}
	}
}

window.onload = function() { pre2ol(); }
