/* ********************************************************
* pre2ol - convert all pre tags to ol ones in a page.
* author  : Olivier Meunier
* version : 0.1 - 2005-03-11
*
* license :
* Creative Commons Attribution-NonCommercial-ShareAlike 2.0
* http://creativecommons.org/licenses/by-nc-sa/2.0/
******************************************************** */
function pre2ol()
{
	if (!document.getElementsByTagName) {
		return;
	}
	
	var pre = document.getElementsByTagName('pre');
	
	if (pre.length == 0) {
		return;
	}
	
	var tab = "\u00A0\u00A0\u00A0\u00A0\u00A0";
	
	for (var i=0; i<pre.length; i++)
	{
		var e = pre.item(i);
		
		var c = e.childNodes.item(0);
		var content = c.data;
		
		if (e.childNodes.length == 1 && content)
		{
			i--;
			content = content.replace(/\r\n/g,'\n');
			content = content.replace(/\r/g,'\n');
			content = content.replace(/\t/g,tab);
			content = content.replace(/  /g,'\u00A0 ');
			
			var lines = content.split('\n')
			
			var ol = document.createElement("ol");
			
			if (e.id) {
				ol.id = e.id;
			}
			
			var className = 'pre2ol';
			if (e.className) {
				className += ' '+e.className;
			}
			ol.className = className;
			
			for (var j=0; j<lines.length; j++)
			{
				if (lines[j] == '') { lines[j] = '\u00A0'; }
				
				var li = document.createElement('li');
				var span = document.createElement('span');
				var newText = document.createTextNode(lines[j]);
				span.appendChild(newText);
				li.appendChild(span);
				ol.appendChild(li);
			}
			var p = e.parentNode;
			p.replaceChild(ol,e);
		}
	}
}


/* GETELEMENTSBYTAGNAMES */

function getElementsByTagNames(list,obj) {
	if (!obj) var obj = document;
	var tagNames = list.split(',');
	var resultArray = new Array();
	for (var i=0;i<tagNames.length;i++) {
		var tags = obj.getElementsByTagName(tagNames[i]);
		for (var j=0;j<tags.length;j++) {
			resultArray.push(tags[j]);
		}
	}
	var testNode = resultArray[0];
	if (!testNode) return [];
	if (testNode.sourceIndex) {
		resultArray.sort(function (a,b) {
				return a.sourceIndex - b.sourceIndex;
		});
	}
	else if (testNode.compareDocumentPosition) {
		resultArray.sort(function (a,b) {
				return 3 - (a.compareDocumentPosition(b) & 6);
		});
	}
	return resultArray;
}

function zebra()
{
	/* Zebra lists */
	
	var lists = getElementsByTagNames('ol');
	for (var i=0;i<lists.length;i++) {
		var items = lists[i].childNodes;
		var counter = 1;
		for (var j=0;j<items.length;j++) {
			if (items[j].nodeName == 'LI' && !items[j].getElementsByTagName('li').length) {
				counter++;
				if (counter % 2 == 1)
					items[j].className = 'lizebra';
			}
		}
	}
}

function addLoadListener(func) 
{
	if (window.addEventListener) {
		window.addEventListener("load", func, false);
	}
	 else if (document.addEventListener) {
		document.addEventListener("load", func, false);
	}
	 else if (window.attachEvent) {
		window.attachEvent("onload", func);
	}
}

addLoadListener(pre2ol);
addLoadListener(zebra);

