<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2008 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Version originale de dsls : http://www.morefnu.org/

if (!defined('DC_CONTEXT_ADMIN')) exit;

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');
require dirname(__FILE__).'/lib/class.freshyOne.config.php';

$config = new freshyOneConfig($core);

$custom_themes_combo = $config->getCustomThemes();
$images = $config->getHeaderImages();
$current_custom_theme = $core->blog->settings->freshyOne_selected;
$current_top_image = $core->blog->settings->freshyOne_header;
if ($current_custom_theme == null) {
	$current_custom_theme = 'default';
	$current_top_image = 'default';
}
if (!empty($_POST))
{
	$current_custom_theme = $_POST['freshyOne_selected'];
	$current_top_image = $_POST['freshyOne_header'];
	if (!isset($images[$current_top_image])) {
		$current_top_image = 'default';
	}
	$core->blog->settings->setNamespace('themes');
	$core->blog->settings->put('freshyOne_selected',$current_custom_theme,'string');
	$core->blog->settings->put('freshyOne_header',$current_top_image,'string');
	$core->blog->triggerBlog();
}
echo '<script type="text/javascript" src="js/_blog_theme.js"></script>';

# Options display
echo '<fieldset><legend>'.__('Top Image').'</legend>';
$nb_img = count($images);
$nb_img_by_col = 1+($nb_img-$nb_img%3)/3;
echo '<div id="imgheaders">';
echo "<p>".form::radio(array('freshyOne_header','default'),'default',$current_top_image=='default').__('Use custom theme default header')."</p>";
$count=0;
echo '<div class="three-cols"><div class="col"><ul>';
foreach ($images as $ref => $image) {
	if ($count != 0 && $count%$nb_img_by_col==0)
		echo '</ul></div><div class="col"><ul>';
	echo '<li style="list-style: none;">'.form::radio(array('freshyOne_header',$ref),$ref,$current_top_image==$ref).'<img src="'.$image['thumb'].'" style="height:32px;length:260px;" alt="'.$ref.'" /></li>';
	$count++;
}
echo '</ul></div></div></div>';
echo '</fieldset>';
echo '<fieldset><legend>'.__('Preferences').'</legend>';
echo
'<p class="field"><label>'.__('Background menu').' '.
form::combo('freshyOne_selected',$config->getCustomThemes(),$current_custom_theme).'</label></p>';
echo '</fieldset>';

?>
