<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_CONTEXT_ADMIN')) { return; }

function qrazytimes_guess_url($url)
{
	global $core;
	
	if (preg_match('/^'.preg_quote($core->blog->url,'/').'/',$url)) {
		return preg_replace('/^'.preg_quote($core->blog->url,'/').'/','',$url);
	}
	
	return $url;
}

$qrazytimes_nav = array();
if ($core->blog->settings->qrazytimes_nav) {
	$qrazytimes_nav = @unserialize($core->blog->settings->qrazytimes_nav);
}

if (!is_array($qrazytimes_nav)) {
	$qrazytimes_nav = array();
}

if (!empty($_POST))
{
	if (!empty($_POST['nav_title']) && !empty($_POST['nav_url']) && !empty($_POST['nav_order']))
	{
		$new_nav = array();
		$nav_title = $_POST['nav_title'];
		$nav_url = $_POST['nav_url'];
		$nav_order = $_POST['nav_order'];
		
		asort($nav_order);
		foreach ($nav_order as $i => $v) {
			if (empty($nav_title[$i]) || !isset($nav_url[$i])) {
				continue;
			}
			$new_nav[] = array(
				$nav_title[$i],
				qrazytimes_guess_url($nav_url[$i])
			);
		}
		
		$qrazytimes_nav = $new_nav;
	}
	
	if (!empty($_POST['new_title']) && isset($_POST['new_url']))
	{
		$qrazytimes_nav[] = array(
			$_POST['new_title'],
			qrazytimes_guess_url($_POST['new_url'])
		);
		
		
	}
	$core->blog->settings->setNameSpace('qrazytimes');
	$core->blog->settings->put('qrazytimes_nav',serialize($qrazytimes_nav),'string');
	$core->blog->triggerBlog();
}

$html_file = path::real($core->blog->themes_path).'/'.$core->blog->settings->theme.'/tpl/_about.html';

if (isset($_POST['html']))
{
	@$fp = fopen($html_file,'wb');
	fwrite($fp,$_POST['html']);
	fclose($fp);
	
	echo '<p class="message">'.__('La configuration du thème a été mise à jour avec succès.').'</p>';
}

$html_content = is_file($html_file) ? file_get_contents($html_file) : '';

echo '<fieldset><legend>'.__('Menu de navigation').'</legend>';

foreach ($qrazytimes_nav as $i => $v)
{
	if ($i == 0) {
		echo '<h4>'.__('Editer les liens').'</h4>';
	}
	
	echo
	'<p><label class="classic">'.__('Titre:').' '.
	form::field(array('nav_title['.$i.']'),15,90,html::escapeHTML($v[0])).'</label> '.
	'<label class="classic">'.__('URL:').' '.
	form::field(array('nav_url['.$i.']'),30,120,html::escapeHTML($v[1])).'</label> '.
	'<label class="classic">'.__('Ordre:').' '.
	form::field(array('nav_order['.$i.']'),2,3,(string) $i).'</label></p>';
}

echo
'<h4>'.__('Ajouter un lien').'</h4>'.
'<p><label class="classic">'.__('Titre:').' '.
form::field(array('new_title'),15,90,'').'</label> '.
'<label class="classic">'.__('URL:').' '.
form::field(array('new_url'),30,120,'').'</label></p>';

echo '<br /><p class="form-note">Pour effacer un lien, laissez le champ vide.</p>';

echo '</fieldset>';

echo '<fieldset><legend>'.__('Bloc de contenu personnalisé').'</legend>';

echo
'<p class="area"><label>'.__('Contenu:').' '.
form::textarea('html',50,7,html::escapeHTML($html_content)).
'</label>'.
'</p>';

echo '</fieldset>';
?>