<?php
# -- BEGIN LICENSE BLOCK -----------------------------
#
# This file is part of Battlestar, a Dotclear 2 theme.
#
# -- END LICENSE BLOCK -------------------------------

if (!defined('DC_CONTEXT_ADMIN')) { return; }

function battlestar_guess_url($url)
{
	global $core;
	
	if (preg_match('/^'.preg_quote($core->blog->url,'/').'/',$url)) {
		return preg_replace('/^'.preg_quote($core->blog->url,'/').'/','',$url);
	}
	
	return $url;
}

$battlestar_nav = array();
if ($core->blog->settings->battlestar_nav) {
	$battlestar_nav = @unserialize($core->blog->settings->battlestar_nav);
}

if (!is_array($battlestar_nav)) {
	$battlestar_nav = array();
}

if (!empty($_POST))
{
	if (!empty($_POST['nav_title']) && !empty($_POST['nav_url']) && !empty($_POST['nav_pos']))
	{
		$new_nav = array();
		$nav_title = $_POST['nav_title'];
		$nav_url = $_POST['nav_url'];
		$nav_pos = $_POST['nav_pos'];
		
		asort($nav_pos);
		foreach ($nav_pos as $i => $v) {
			if (empty($nav_title[$i]) || !isset($nav_url[$i])) {
				continue;
			}
			$new_nav[] = array(
				$nav_title[$i],
				battlestar_guess_url($nav_url[$i])
			);
		}
		
		$battlestar_nav = $new_nav;
	}
	
	if (!empty($_POST['new_title']) && isset($_POST['new_url']))
	{
		$battlestar_nav[] = array(
			$_POST['new_title'],
			battlestar_guess_url($_POST['new_url'])
		);
		
		
	}
	$core->blog->settings->setNameSpace('battlestar');
	$core->blog->settings->put('battlestar_nav',serialize($battlestar_nav),'string');
	$core->blog->triggerBlog();
}



echo '<fieldset><legend>'.__('Menu de Navigation').'</legend>';

foreach ($battlestar_nav as $i => $v)
{
	if ($i == 0) {
		echo '<h4>'.__('Editer les liens').'</h4>';
	}
	
	echo
	'<p><label class="classic">'.__('Nom:').' '.
	form::field(array('nav_title['.$i.']'),15,90,html::escapeHTML($v[0])).'</label> '.
	'<label class="classic">'.__('URL:').' '.
	form::field(array('nav_url['.$i.']'),30,120,html::escapeHTML($v[1])).'</label> '.
	'<label class="classic">'.__('Position:').' '.
	form::field(array('nav_pos['.$i.']'),2,3,(string) $i).'</label></p>';
}

echo
'<h4>'.__('Ajouter un lien').'</h4>'.
'<p><label class="classic">'.__('Nom:').' '.
form::field(array('new_title'),15,90,'').'</label> '.
'<label class="classic">'.__('URL:').' '.
form::field(array('new_url'),30,120,'').'</label></p>';


echo '</fieldset>';
?>