<?php
# -- BEGIN LICENSE BLOCK -----------------------------
#
# This file is part of Battlestar, a Dotclear 2 theme.
#
# -- END LICENSE BLOCK -------------------------------

if (!defined('DC_RC_PATH')) { return; }

$core->tpl->addValue('BattlestarMenu',array('tplBattlestar','BattlestarMenu'));

class tplBattlestar
{
	public static function BattlestarMenu($attr,$content)
	{
		$list = !empty($attr['list']) ? $attr['list'] : '';
		$item = !empty($attr['item']) ? $attr['item'] : '';
		$active_item = !empty($attr['active_item']) ? $attr['active_item'] : '';
		
		return "<?php echo tplBattlestar::BattlestarMenuHelper('".addslashes($list)."','".addslashes($item)."','".addslashes($active_item)."'); ?>";
	}
	
	public static function BattlestarMenuHelper($list,$item,$active_item)
	{
		global $core;
		
		$menu = @unserialize($core->blog->settings->battlestar_nav);
		if (!is_array($menu) || empty($menu)) {
			$menu = array(array(
				'Accueil',
				''
			));
		}
		
		$list = $list ? html::decodeEntities($list) : '<ul>%s</ul>';
		$item = $item ? html::decodeEntities($item) : '<li><a href="%s">%s</a></li>';
		$active_item = $active_item ? html::decodeEntities($active_item) : '<li class="nav-active"><a href="%s">%s</a></li>';
		
		$current = -1;
		$current_size = 0;
		
		$self_uri = http::getSelfURI();
		foreach ($menu as $k => &$v)
		{
			$v[1] = preg_match('$^(/|[a-z][a-z0-9.+-]+://)$',$v[1]) ? $v[1] : $core->blog->url.$v[1];
			
			if (strlen($v[1]) > $current_size && preg_match('/^'.preg_quote($v[1],'/').'/',$self_uri)) {
				$current = $k;
				$current_size = strlen($v[1]);
			}
		}
		unset($v);
		
		$res = '';
		foreach ($menu as $i => $v)
		{
			if ($i == $current) {
				$res .= sprintf($active_item,html::escapeHTML($v[1]),html::escapeHTML($v[0]));
			} else {
				$res .= sprintf($item,html::escapeHTML($v[1]),html::escapeHTML($v[0]));
			}
		}
		
		return sprintf($list,$res);
	}
}

?>