(function($){
	jQuery.fn.extend ({
		
		//Main shadowise function
		shadowise:function (params) {
			// If image il already loaded in DOM, apply hte shadow
			// effect 
			if ($(this).attr('complete')) {
				$(this).applyShadow(params);
			}
			// else, we will apply shadow effet wen image will be
			// loaded...
			else {
				$(this).bind('load', function () { $(this).applyShadow(params); });
			}
			return this;	
		},
		
		//function to apply shadow 
		applyShadow:function (params) {

			// function parameters ...
			var params = $.extend({
				minSize: 180,
				medSize: 330
			},params);
			// if our image is greater than minSize
			if ($(this).width() > params.minSize && $(this).height() > params.minSize) {
				//we save image style and class
				var imgStyle = $(this).attr("style");
				var imgClass = $(this).attr("class");

				// delete all style in our image
				$(this).attr("style", "");
				$(this).attr("class", "");
				$(this).addClass ("image-sw");
				$(this).addClass ("layout-sw");
				// if our image less than medSize, we add only two shadow (left-bottom and right-top)				
				if (parseInt($(this).width()) < params.medSize || parseInt($(this).height()) < params.medSize) {
					spanImg = "<span style='" + imgStyle + "' class='imageLB-sw layout-sw "+imgClass+"'><span class='imageRT-sw'></span></span>";
				} else {
					// else we add 4 shadows
					spanImg = "<span style='"+imgStyle+"' class='imageLT-sw "+imgClass+"'><span class='imageLB-sw'><span class='imageRT-sw'><span class='imageRB-sw '></span></span></span></span>";
				}
				$(this).wrap(spanImg);
				$('.imageLT-sw, .imageLB-sw, .imageRT-sw, .imageRB-sw').css('display', 'inline-block');
				//$('.imageLT-sw, .imageLB-sw, .imageRT-sw, .imageRB-sw').css('margin','0');
			} else {
				//we apply tooShort-sw css class if our image is less than minSize
				$(this).addClass("tooShort-sw");
			}
			return this;
		}	
	});
})(jQuery);
