
//Fichier JS pour le formulaire de contact
// Nécéssite JQuery

//Plugins pour les formulaire
// Ceci est un test, et en plus, c'est surement très mal programmé
(function($){


jQuery.fn.extend ({

	hideLabel:function(){
		$(this).prev().css("display", "none");
		return this;
	},

	/* inputInteraction
	 * ----------------
	 * Cette fonction gère l'accès a une zone de texte. celle ci prend la valeur par
	 * défaut (text), et prend une autre valeurs (textFocus) lorsque l'input obtient
	 * le focus
	 *
	 */

	addText:function (params){
		var params = $.extend({
			text : 'Entrez un texte Ici',
			textFocus : ''
		},params);
		// On met un tit texte dans notre input...
		$(this).val(params.text);
		$(this).focus(function(){
			var valueTxt = $(this).attr("value");
			if ( valueTxt == params.text) {
				$(this).val(params.textFocus);
			}
		})
		.blur(function () {
			var valueTxt = $(this).attr("value");
			if (valueTxt == undefined || valueTxt == params.textFocus) {
				$(this).val(params.text);		
			}
		});
		return this;
	},

	/* emalInput
	 * ---------
	 * Fonction qui gère un champs input spécifique au champ email. Elle fait la vérifica-
	 * tion de la saisie 
	 */
	emailInput:function(params){
		var params = $.extend({
			onValid:function (){},
			onError:function (){}
		},params);
		
		$(this).blur( function (){
			var eregMail = new RegExp ( "^\\w[\\w\.\-]*@[\\w\-\.]*[.][a-zA-Z]{2,4}$", "gi" );
			var email =  $(this).attr("value");
			if (eregMail.exec(email)) {
				params.onValid();
			}
			else {
				params.onError();
			}
		});
		return this;
	},

	/* urlInput
	 * ---------
	 * Fonction qui gère un champs input spécifique au site web. Elle fait la vérifica-
	 * tion de la saisie 
	 */
	urlInput:function(params){
		var params = $.extend({
			onValid:function (){console.log ("URL valide");},
			onError:function (){console.log ("URL non valide");}
		},params);
		
		$(this).blur( function (){
			var eregURL = new RegExp ( "^(http|https):\/\/[\\w\.\-]*[.][a-zA-Z]{2,4}(|\/[\\w\~\#\!\:\.\?\+\=\&\%\@\!\-\/]*)$", "gi" );
			var url =  $(this).attr("value");
			if (eregURL.exec(url)) {
				params.onValid();
			}
			else {
				params.onError();
			}
		});
		return this;
	},
	
	isAnUrl:function(){
		var eregURL = new RegExp ( "^(http|https):\/\/[\\w\.\-]*[.][a-zA-Z]{2,4}(|\/[\\w\~\#\!\:\.\?\+\=\&\%\@\!\-\/]*)$", "gi" );
		var url =  $(this).attr("value");
		if (eregURL.exec(url)) {
			return true;
		}
		else {
			return false;
		}
	},

	isAnEmail:function(){
		var eregEmail = new RegExp ( "^\\w[\\w\.\-]*@[\\w\-\.]*[.][a-zA-Z]{2,4}$", "gi" ); 
		var email =  $(this).attr("value");
		return eregEmail.exec(email)
	},

	isEmpty:function() {
		if ($(this).attr("value")){
			return false;
		}
		return true;
	},
	
	setFalse:function () {
		var offset = $(this).offset();
		var errorMsg = $('<p class="errorMsg"></p>');
		errorMsg.appendTo('body');
		errorMsg.css({
			position:'absolute',
			padding:0,
			margin:0,
			zIndex:50,
			width:'160px',
			height:'30px',
			background:'url(/themes/carnet/js/contact/acorriger.png) no-repeat center left',
			top:offset.top - ( 15 -$(this).height()/2),
			left:offset.left + ($(this).width() * 0.70)
		});
		$(this).focus(function(){
			errorMsg.fadeOut('fast',function(){$(this).remove();});				
		});
	}


});
})(jQuery)
		
$(document).ready(function() {
	
	$(".nom input").hideLabel().addText({
		text:"*<Votre nom ici>"
	});
	$(".mail input").hideLabel().addText({
		text:"*<Votre email ici>"
	}).emailInput();
	$(".site input").hideLabel().addText({
		text:"<Votre site internet ici>",
		textFocus:"http://"
	}).urlInput();
	$(".message textarea").hideLabel().addText({
		text:"*<Votre Message ici>"
	});

	//Validation du formulaire
	$("#contactForm").submit(function(){
		if ($(".nom input").attr("value") == "*<Votre nom ici>" || $(".nom input").attr("value") == "") {
			$(".nom input").setFalse();
			return false;
		}

		if (!$(".mail input").isAnEmail()) {
			$(".mail input").setFalse();
			return false;
		}

		if (!$(".site input").isAnUrl()) {
			if ($(".site input").attr("value") != "<Votre site internet ici>") {
				$(".site input").setFalse();
				return false;
			}
		}
		if ($(".message textarea").attr("value") == "*<Votre Message ici>") {
			$(".message textarea").setFalse();
			return false;
		}

		return true;
	});
	
});
