<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2009 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_RC_PATH')) { return; }

$core->addBehavior('publicHeadContent',array('tplCustomTheme','publicHeadContent'));

class tplCustomTheme
{
	public static function publicHeadContent(&$core)
	{
		echo
		'<style type="text/css">'."\n".
		'@import url('.$core->blog->settings->public_url.'/custom_style.css);'."\n".
		"</style>\n";
	}
}

class myLovelyTemplates
{
        public static function EntriesCount($attr)
        {
                $p = "if (!is_array(\$params)) \$params = array();
";

                if (isset($attr['author'])) {
                        $p .= "\$params['user_id'] = '".addslashes($attr['author'])."';
";
                }

                if (isset($attr['category'])) {
                        $p .= "\$params['cat_url'] = '".addslashes($attr['category'])."';
";
                        $p .= "context::categoryPostParam(\$params);
";
                }

                if (isset($attr['no_category'])) {
                        $p .= "\$params['sql'] .= ' AND P.cat_id IS NULL ';
";
                        $p .= "unset(\$params['cat_url']);
";
                }

                if (!empty($attr['type'])) {
                        $p .= "\$params['post_type'] = preg_split('/\s*,\s*/','".addslashes($attr['type'])."',-1,PREG_SPLIT_NO_EMPTY);
";
                }

                if (isset($attr['tag'])) {
                        $p .= 
                                "\$params['from'] .= ', '.\$core->prefix.'meta META ';
".
                                "\$params['sql'] .= 'AND META.post_id = P.post_id ';
".
                                "\$params['sql'] .= \"AND META.meta_type = 'tag' \";
".
                                "\$params['sql'] .= \"AND META.meta_id = '".$GLOBALS['core']->con->escape($attr['tag'])."' \";
";
                }

                if (empty($attr['no_context'])) {
                        $p .=
                                'if ($_ctx->exists("users")) { '.
                                        "\$params['user_id'] = \$_ctx->users->user_id; ".
                                "}
";

                        $p .=
                                'if ($_ctx->exists("categories")) { '.
                                        "\$params['cat_id'] = \$_ctx->categories->cat_id; ".
                                "}
";

                        $p .=
                                'if ($_ctx->exists("archives")) { '.
                                        "\$params['post_year'] = \$_ctx->archives->year(); ".
                                        "\$params['post_month'] = \$_ctx->archives->month(); ".
                                        "unset(\$params['limit']); ".
                                "}
";

                        $p .=
                                'if ($_ctx->exists("langs")) { '.
                                        "\$params['post_lang'] = \$_ctx->langs->post_lang; ".
                                "}
";

                        $p .=
                                'if (isset($_search)) { '.
                                        "\$params['search'] = \$_search; ".
                                "}
";

                        $p .=
                                'if ($_ctx->exists("meta")) { '.
                                        "\$params['from'] .= ', '.\$core->prefix.'meta META ';
".
                                        "\$params['sql'] .= 'AND META.post_id = P.post_id ';
".
                                        "\$params['sql'] .= \"AND META.meta_type = 'tag' \";
".
                                        "\$params['sql'] .= \"AND META.meta_id = '\".\$core->con->escape(\$_ctx->meta->meta_id).\"' \";
".
                                "}
";
                }

                if (isset($attr['selected'])) {
                        $p .= "\$params['post_selected'] = ".(integer) (boolean) $attr['selected'].";";
                }

                return
                        "<?php
".
                        $p.
                        '$_ctx->post_params = $params;'."
".
                        '$_ctx->posts = $core->blog->getPosts($params,true); unset($params);'."
".
                        'echo $_ctx->posts->f(0);'."
".
                        '$_ctx->posts = null; $_ctx->post_params = null;'."
".
                        "?>
";
        }
}

$core->tpl->addValue('EntriesCount',array('myLovelyTemplates','EntriesCount'));

$core->addBehavior('templateBeforeBlock',array('behaviorsExcludeCurrentPost','templateBeforeBlock'));

class behaviorsExcludeCurrentPost 
{
	public static function templateBeforeBlock($core,$b,$attr)
	{
	       if ($b == 'Entries' && isset($attr['exclude_current']) && $attr['exclude_current'] == 1)
	       {
		       return
		       "<?php\n".
		       '$params["sql"] = "AND P.post_url != \'".$_ctx->posts->post_url."\' ";'."\n".
		       "?>\n";
	       }
	}
}

$core->tpl->addBlock('TagsIfFirstLetter',array('TagsFL','TagsIfFirstLetter'));

$core->tpl->addValue('TagsFirstLetter',array('TagsFL','TagsFirstLetter'));

class TagsFL
{
	# <tpl:TagsIfFirstLetter> ... </tpl:TagsIfFirstLetter>
	public static function TagsIfFirstLetter($attr,$content)
	{
		return
		'<?php '.
		'if (mb_strlen($_ctx->TagsFirstLetter) == 0) {$_ctx->TagsFirstLetter = null;}'.
		'$_ctx->TagsFirstLetter = mb_strtoupper(text::cutString($_ctx->meta->meta_id,1));'.
		'if ($_ctx->TagsFirstLetter != $_ctx->TagsFirstLetter_next) : '.
		'?>'.
		$content.
		'<?php endif;'.
		'$_ctx->TagsFirstLetter_next = $_ctx->TagsFirstLetter;'.
		' ?>';
	}
	
	# {{tpl:TagsFirstLetter}}
	public static function TagsFirstLetter($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		
		return
		'<?php echo($_ctx->TagsFirstLetter); ?>';
	}
}

?>