<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# BlueSky :
# http://www.html-edition.com/dotclear/billet/158
# http://www.html-edition.com/
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_RC_PATH')) { return; }

# Language additions
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/public');

# Add specific CSS colors in <head>
// style pour l'affichage des saisons
$core->addBehavior('publicHeadContent','MyPrettyThemeStyle_publicHeadContent');

function MyPrettyThemeStyle_publicHeadContent($core)
{
	$style = $core->blog->settings->themes->MyPrettyThemeStyle_style;
	if (!preg_match('/^blue|dark_blue$/',$style)) {
		$style = 'blue';
	}

	$url = $core->blog->settings->themes_url.'/'.$core->blog->settings->theme;
	echo '<link rel="stylesheet" type="text/css" media="screen" href="'.$url."/colors/".$style.".css\" />\n";
}

# Display tags by letters
$core->tpl->addBlock('TagsIfFirstLetter',array('TagsFL','TagsIfFirstLetter'));
$core->tpl->addValue('TagsFirstLetter',array('TagsFL','TagsFirstLetter'));

class TagsFL
{
	# <tpl:TagsIfFirstLetter> ... </tpl:TagsIfFirstLetter>
	public static function TagsIfFirstLetter($attr,$content)
	{
		return
		'<?php '.
		'if (mb_strlen($_ctx->TagsFirstLetter) == 0) {$_ctx->TagsFirstLetter = null;}'.
		'$_ctx->TagsFirstLetter = mb_strtoupper(text::cutString($_ctx->meta->meta_id,1));'.
		'if ($_ctx->TagsFirstLetter != $_ctx->TagsFirstLetter_next) : '.
		'?>'.
		$content.
		'<?php endif;'.
		'$_ctx->TagsFirstLetter_next = $_ctx->TagsFirstLetter;'.
		' ?>';
	}
	
	# {{tpl:TagsFirstLetter}}
	public static function TagsFirstLetter($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		
		return
		'<?php echo($_ctx->TagsFirstLetter); ?>';
	}
}

# Display total entries per tag
$core->tpl->addValue('CountTagEntries', array('tplMyThemeAdditions', 'CountTagEntries'));

class tplMyThemeAdditions {
	public static function CountTagEntries($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		$n = '$_ctx->meta->count';
		
		return '<?php echo '.sprintf($f, $n).'; ?>';
	}
}

# Ajax search URL (Modified code from Olivier Meunier http://themes.dotaddict.org/galerie-dc2/details/Noviny)
# Ajax search URL
$core->url->register('ajaxsearch','ajaxsearch','^ajaxsearch(?:(?:/)(.*))?$',array('urlsNoviny','ajaxsearch'));

class tplNoviny
{
	public static function NovinyMenu($attr,$content)
	{
		$list = !empty($attr['list']) ? $attr['list'] : '';
		$item = !empty($attr['item']) ? $attr['item'] : '';
		$active_item = !empty($attr['active_item']) ? $attr['active_item'] : '';
		
		return "<?php echo tplNoviny::NovinyMenuHelper('".addslashes($list)."','".addslashes($item)."','".addslashes($active_item)."'); ?>";
	}
	
	public static function NovinyMenuHelper($list,$item,$active_item)
	{
		global $core;
		
		$menu = @unserialize($core->blog->settings->noviny_nav);
		if (!is_array($menu) || empty($menu)) {
			$menu = array(array(
				'Blog',
				''
			));
		}
		
		$list = $list ? html::decodeEntities($list) : '<ul>%s</ul>';
		$item = $item ? html::decodeEntities($item) : '<li><a href="%s">%s</a></li>';
		$active_item = $active_item ? html::decodeEntities($active_item) : '<li class="nav-active"><a href="%s">%s</a></li>';
		
		$current = -1;
		$current_size = 0;
		
		# Clean urls and find current menu zone
		$self_uri = http::getSelfURI();
		foreach ($menu as $k => &$v)
		{
			$v[1] = preg_match('$^(/|[a-z][a-z0-9.+-]+://)$',$v[1]) ? $v[1] : $core->blog->url.$v[1];
			
			if (strlen($v[1]) > $current_size && preg_match('/^'.preg_quote($v[1],'/').'/',$self_uri)) {
				$current = $k;
				$current_size = strlen($v[1]);
			}
		}
		unset($v);
		
		$res = '';
		foreach ($menu as $i => $v)
		{
			if ($i == $current) {
				$res .= sprintf($active_item,html::escapeHTML($v[1]),html::escapeHTML($v[0]));
			} else {
				$res .= sprintf($item,html::escapeHTML($v[1]),html::escapeHTML($v[0]));
			}
		}
		
		return sprintf($list,$res);
	}
}

class urlsNoviny
{
	public static function ajaxsearch($args)
	{
		global $core;
		$res = '';
		
		try
		{
			if (!$args) {
				throw new Exception;
			}
			
			$q = rawurldecode($args);
			$rs = $core->blog->getPosts(array(
				'search' => $q,
				'limit' => 5
			));
			
			if ($rs->isEmpty()) {
				throw new Exception;
			}
			
			$res = '<ul>';
			while ($rs->fetch())
			{
				$res .= '<li><a href="'.$rs->getURL().'">'.html::escapeHTML($rs->post_title).'</a></li>';
			}
			$res .= '</ul>';
		}
		catch (Exception $e) {}
		
		header('Content-Type: text/plain; charset=UTF-8');
		echo $res;
	}
}
?>