<?php
/* -- BEGIN LICENSE BLOCK ---------------------------------------
# This file is part of minimal, a theme for Dotclear
#
# Copyright (c) 2013 - nico_somb http://www.cdetc.fr
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ----------------------------------------- */

if (!defined('DC_CONTEXT_ADMIN')) { return; }

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/admin');


$minimal_base = array(
	'inverted_version' => null
);


$minimal_version = $core->blog->settings->themes->get($core->blog->settings->system->theme.'_version');
$minimal_version = @unserialize($minimal_version);
if (!is_array($minimal_version)) {
	$minimal_version = array();
}
$minimal_version = array_merge($minimal_base,$minimal_version);

if (!empty($_POST))
{
	try
	{
		$minimal_version['inverted_version'] = (integer) !empty($_POST['inverted_version']);

		$core->blog->settings->addNamespace('themes');
		$core->blog->settings->themes->put($core->blog->settings->system->theme.'_version',serialize($minimal_version));

		// Blog refresh
		$core->blog->triggerBlog();

		// Template cache reset
		$core->emptyTemplatesCache();
		
		dcPage::message(__('Theme configuration upgraded.'),true,true);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

echo '<fieldset><legend>'.__('Version').'</legend>'.
'<p class="field"><label for="inverted_version">'.__('Inverted version:').' '.
form::checkbox('inverted_version', 1, $minimal_version['inverted_version']).'</label>'.'</p>';
echo '</fieldset>';
