<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of DonCarlo, a Dotclear 2 theme by Kozlika.
# Thanks to Olivier Meunier for this script
#
# Copyright (c) 2003-2009 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# Last change: 2/1/2009 by Franck Paul 
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_RC_PATH')) { return; }

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/public');

# We add some scripts in all pages
$core->addBehavior('publicHeadContent',array('behaviorsDonCarlo','publicHeadContent'));

# All tags go to archives
$core->url->unregister('tags');
$core->url->register('tags','tags','^tags$',array('dcUrlHandlers','archive'));

# Ajax search URL
$core->url->register('ajaxsearch','ajaxsearch','^ajaxsearch(?:(?:/)(.*))?$',array('urlsDonCarlo','ajaxsearch'));

class behaviorsDonCarlo
{
	public static function publicHeadContent($core)
	{
		echo
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		'var doncarlo = { '.
		"ajaxsearch: '".html::escapeJS($core->blog->url.$core->url->getBase('ajaxsearch'))."/' ".
		"};\n".
		"//]]>\n".
		"</script>\n".
		'<script type="text/javascript" src="'.$core->blog->settings->themes_url.'/'.$core->blog->settings->theme.'/search.js"></script>';
	}
}

class urlsDonCarlo
{
	public static function ajaxsearch($args)
	{
		global $core;
		$res = '';
		
		try
		{
			if (!$args) {
				throw new Exception;
			}
			
			$q = rawurldecode($args);
			$rs = $core->blog->getPosts(array(
				'search' => $q,
				'limit' => 5
			));
			
			if ($rs->isEmpty()) {
				throw new Exception;
			}
			
			$res = '<ul>';
			while ($rs->fetch())
			{
				$res .= '<li><a href="'.$rs->getURL().'">'.html::escapeHTML($rs->post_title).'</a></li>';
			}
			$res .= '</ul>';
		}
		catch (Exception $e) {}
		
		header('Content-Type: text/plain; charset=UTF-8');
		echo $res;
	}
}
?>