<?php
# ***** BEGIN LICENSE BLOCK *****
#
#  	StudioPress
#  	Theme by Fran6t
#   Contributor : Pierre Van Glabeke
#   original WP theme: http://www.dailyblogtips.com/wordpress-themes
#   License : http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# ***** END LICENSE BLOCK *****
if (!defined('DC_CONTEXT_ADMIN')) { return; }

// chargement de la traduction
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');

// affichage du type de menu
$studiopress_menus = array(
	__('menuFreshy or menu (Adjaya)') => 'menufreshy',
	__('simpleMenu') => 'simplemenu'
);

if (!$core->blog->settings->themes->studiopress_menu) {
	$core->blog->settings->themes->studiopress_menu = 'menufreshy';
}

if (!empty($_POST['studiopress_menu']) && in_array($_POST['studiopress_menu'],$studiopress_menus))
{
	$core->blog->settings->themes->studiopress_menu = $_POST['studiopress_menu'];
	$core->blog->settings->addNamespace('themes');
	$core->blog->settings->themes->put('studiopress_menu',$core->blog->settings->themes->studiopress_menu,'string','Menu to display',true);
	$core->blog->triggerBlog();

	dcPage::success(__('Theme configuration has been successfully updated.'));
}

echo
'<div class="fieldset"><h4>'.__('Customizations').'</h4>'.
'<p class="field"><label>'.__('Menu to display:').'</label>'.
form::combo('studiopress_menu',$studiopress_menus,$core->blog->settings->themes->studiopress_menu).
'</p>';

#insert welcome
$html_filewelcome = path::real($core->blog->themes_path).'/'.$core->blog->settings->system->theme.'/tpl/inc-welcome.html';

if (!is_file($html_filewelcome) && !is_writable(dirname($html_filewelcome))) {
	throw new Exception(
		sprintf(__('File %s does not exist and directory %s is not writable.'),
		$css_filewelcome,dirname($html_filewelcome))
	);
}

if (isset($_POST['welcome']))
{
	@$fp = fopen($html_filewelcome,'wb');
	fwrite($fp,$_POST['welcome']);
	fclose($fp);
}

$html_contentwelcome = is_file($html_filewelcome) ? file_get_contents($html_filewelcome) : '';

echo
'<p class="area"><label for="welcome">'.__('Welcome text:').' '.
form::textarea('welcome',60,10,html::escapeHTML($html_contentwelcome)).'</label></p>';

#top insert
$html_filetop = path::real($core->blog->themes_path).'/'.$core->blog->settings->system->theme.'/tpl/inc-pubcentrale.html';

if (!is_file($html_filetop) && !is_writable(dirname($html_filetop))) {
	throw new Exception(
		sprintf(__('File %s does not exist and directory %s is not writable.'),
		$css_filetop,dirname($html_filetop))
	);
}

if (isset($_POST['topinsert']))
{
	@$fp = fopen($html_filetop,'wb');
	fwrite($fp,$_POST['topinsert']);
	fclose($fp);
}

$html_contenttop = is_file($html_filetop) ? file_get_contents($html_filetop) : '';

echo
'<p class="info">'.__('Dimensions of inserts (for the record): top insert: 468x60px - right insert: 336x280px').'</p>'.
'<p class="area"><label for="topinsert">'.__('Top insert:').' '.
form::textarea('topinsert',60,10,html::escapeHTML($html_contenttop)).'</label></p>';

#right insert
$html_fileright = path::real($core->blog->themes_path).'/'.$core->blog->settings->system->theme.'/tpl/inc-pubdroite.html';

if (!is_file($html_fileright) && !is_writable(dirname($html_fileright))) {
	throw new Exception(
		sprintf(__('File %s does not exist and directory %s is not writable.'),
		$css_fileright,dirname($html_fileright))
	);
}

if (isset($_POST['rightinsert']))
{
	@$fp = fopen($html_fileright,'wb');
	fwrite($fp,$_POST['rightinsert']);
	fclose($fp);
}

$html_contentright = is_file($html_fileright) ? file_get_contents($html_fileright) : '';

echo
'<p class="area"><label for="rightinsert">'.__('Right insert:').' '.
form::textarea('rightinsert',60,10,html::escapeHTML($html_contentright)).'</label></p></div>';
?>