<?php

if (!defined('DC_CONTEXT_ADMIN')) { return; }

// chargement de la traduction
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/admin');

// Initialisation
$StoneStructure_styles = array(
	"1 colonne" => 'structure-fixed-1col-bottom',
	"2 colonnes, sidebar à gauche" => 'structure-fixed-2col-left',
	"2 colonnes, sidebar à droite" => 'structure-fixed-2col-right',
	"3 colonnes, sidebar à gauche" => 'structure-fixed-3col-left',
	"3 colonnes, sidebar middle" => 'structure-fixed-3col-middle',
	"3 colonnes, sidebar à droite" => 'structure-fixed-3col-right'
);
$StoneStyle_styles = array(
	__('Classic Red') => 'style-classic-red',
	__('Classic Blue') => 'style-classic-blue',
	__('Custom') => 'colour-custom'
);
$StonePolice_styles = array(
	__('Arial') => 'police-arial',
	__('Georgia') => 'police-georgia'
);

// Traitement à l'enregistrement
$need_update = false;

if (!$core->blog->settings->themes->StoneStructure_style) {
	$core->blog->settings->themes->StoneStructure_style = 'structure-fixed-1col-bottom';
}

if (!$core->blog->settings->themes->StoneStyle_style) {
	$core->blog->settings->themes->StoneStyle_style = 'style-classic-red';
}

if (!$core->blog->settings->themes->StonePolice_style) {
	$core->blog->settings->themes->StonePolice_style = 'police-arial';
}


if (!empty($_POST['StoneStructure_style']) && in_array($_POST['StoneStructure_style'],$StoneStructure_styles))
{
	$core->blog->settings->themes->StoneStructure_style = $_POST['StoneStructure_style'];
	$core->blog->settings->addNamespace('themes');
	$core->blog->settings->themes->put('StoneStructure_style',$core->blog->settings->StoneStructure_style,'string','Stone - Structure',true);
	$need_update = true;
}

if (!empty($_POST['StoneStyle_style']) && in_array($_POST['StoneStyle_style'],$StoneStyle_styles))
{
	$core->blog->settings->themes->StoneStyle_style = $_POST['StoneStyle_style'];
	$core->blog->settings->addNamespace('themes');
	$core->blog->settings->themes->put('StoneStyle_style',$core->blog->settings->StoneStyle_style,'string','Stone - Style',true);
	$need_update = true;
}

if (!empty($_POST['StonePolice_style']) && in_array($_POST['StonePolice_style'],$StonePolice_styles))
{
	$core->blog->settings->themes->StonePolice_style = $_POST['StonePolice_style'];
	$core->blog->settings->addNamespace('themes');
	$core->blog->settings->themes->put('StonePolice_style',$core->blog->settings->StonePolice_style,'string','Stone - Police',true);
	$need_update = true;
}

// Affichage d'un menu déroulant proposant le choix de la déclinaison 
if ($need_update) {
   $core->blog->triggerBlog();
   dcPage::message(__('Theme configuration has been successfully updated.'));
}

echo
'<fieldset><legend>'.__('Personnalisation').'</legend>'.
'<p class="field"><label>'.__('Structure :').'</label>'.
form::combo('StoneStructure_style',$StoneStructure_styles,$core->blog->settings->themes->StoneStructure_style).
'</p>'.

'<p class="field"><label>'.__('Style :').'</label>'.
form::combo('StoneStyle_style',$StoneStyle_styles,$core->blog->settings->themes->StoneStyle_style).
'</p>'.

'<p class="field"><label>'.__('Police :').'</label>'.
form::combo('StonePolice_style',$StonePolice_styles,$core->blog->settings->themes->StonePolice_style).
'</p>'.
'</fieldset>';