<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of tabsOne, a Dotclear 2 theme.
#
# Copyright (c) 2008 pyeb and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------

if (!defined('DC_CONTEXT_ADMIN')) { return; }

global $core;

//PARAMS

# Translations
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');

# Default values
$default_color = 'green';

# Settings
$my_color = $core->blog->settings->themes->tabsOne_color;

# Color type
$tabsOne_color_combo = array(
	__('green/black/orange') => 'green',
	__('blue/black/orange') => 'blue',
	__('magenta/black/green') => 'magenta'
);

// POST ACTIONS

if (!empty($_POST))
{
	try
	{
		$core->blog->settings->addNamespace('themes');

		# Menu
		if (!empty($_POST['tabsOne_color']) && in_array($_POST['tabsOne_color'],$tabsOne_color_combo))
		{
			$my_color = $_POST['tabsOne_color'];

		} elseif (empty($_POST['tabsOne_color']))
		{
			$my_color = $default_color;

		}
		$core->blog->settings->themes->put('tabsOne_color',$my_color,'string','Color to display',true);

		// Blog refresh
		$core->blog->triggerBlog();

		// Template cache reset
		$core->emptyTemplatesCache();

		dcPage::success(__('Theme configuration has been successfully updated.'),true,true);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

// DISPLAY

# Menu
echo
'<div class="fieldset"><h4>'.__('Colors').'</h4>'.
'<p class="field"><label>'.__('Display:').'</label>'.
form::combo('tabsOne_color',$tabsOne_color_combo,$my_color).
'</p>'.
'</div>';