<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Coal Dust, a Dotclear 2 theme.
#
# Copyright (c) 2003-2009 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_CONTEXT_ADMIN')) { return; }

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/admin');

//lecture des réglages
$polyvalence_ns = $core->blog->settings->addNameSpace('polyvalence');

$asXHTML = $polyvalence_ns->polyvalence_xhtmlxml;
$polyvalence_SN = $polyvalence_ns->polyvalence_social_networks;
$polyvalence_SN_links = $polyvalence_ns->polyvalence_social_networks_links;
$polyvalence_SN_buttons = $polyvalence_ns->polyvalence_social_networks_buttons;
$polyvalence_SN_twitter_cards = $polyvalence_ns->polyvalence_social_networks_twitter_cards;
$polyvalence_SN_twitter_cards_user = $polyvalence_ns->polyvalence_social_networks_twitter_cards_user;
$polyvalence_SN_twitter_cards_website = $polyvalence_ns->polyvalence_social_networks_twitter_cards_website;
$polyvalence_ie_meta = $polyvalence_ns->polyvalence_ie_meta;

if (!empty($_POST))
{
	$core->blog->settings->addNameSpace('polyvalence');

	$asXHTML = (!empty($_POST['polyvalence_xhtmlxml']));
	$polyvalence_ns->put('polyvalence_xhtmlxml',
			$asXHTML,
			'boolean', 'Sending pages as xhtml5 instead of html5 (Pages and content must be valid)');
	# update setting
	
	$polyvalence_SN = (!empty($_POST['polyvalence_social_networks']));
	$polyvalence_ns->put('polyvalence_social_networks',
			$polyvalence_SN,
			'boolean', 'Open Graph protocol inserted');
	
	$polyvalence_SN_links = (!empty($_POST['polyvalence_social_networks_links']));
	$polyvalence_ns->put('polyvalence_social_networks_links',
			$polyvalence_SN_links,
			'boolean', 'Links to social networks');
	
	$polyvalence_SN_buttons = (!empty($_POST['polyvalence_social_networks_buttons']));
	$polyvalence_ns->put('polyvalence_social_networks_buttons',
			$polyvalence_SN_buttons,
			'boolean', 'Social Networks Buttons');

	$polyvalence_SN_twitter_cards = (!empty($_POST['polyvalence_social_networks_twitter_cards']));
	$polyvalence_ns->put('polyvalence_social_networks_twitter_cards',
			$polyvalence_SN_twitter_cards,
			'boolean', 'Twitter Cards metas');

	$polyvalence_SN_twitter_cards_user = $_POST['polyvalence_social_networks_twitter_cards_user'];
	$polyvalence_ns->put('polyvalence_social_networks_twitter_cards_user',
			$polyvalence_SN_twitter_cards_user,
			'string', 'Twitter Cards user ID');
	$polyvalence_SN_twitter_cards_user = $_POST['polyvalence_social_networks_twitter_cards_user'];

	$polyvalence_SN_twitter_cards_website = $_POST['polyvalence_social_networks_twitter_cards_website'];
	$polyvalence_ns->put('polyvalence_social_networks_twitter_cards_website',
			$polyvalence_SN_twitter_cards_website,
			'string', 'Twitter Cards website ID');

	$polyvalence_ie_meta = $_POST['polyvalence_ie_meta'];
	$polyvalence_ns->put('polyvalence_ie_meta',
			$polyvalence_ie_meta,
			'boolean', 'IE meta');


	$core->blog->triggerBlog();
	dcPage::message(__('Configuration updated.'));
}


echo '<div class="fieldset"><h3>'.__('Open Graph protocol').'</h3>';

echo '<p>'.__('Don\'t use chekboxes below if you already have a plugin that manage social networks.').'</p>';

echo '<p>'.
	form::checkbox('polyvalence_social_networks','1',$polyvalence_SN).
	'<label class="classic" for="polyvalence_social_networks">'.
		__('Insert minimal informations wthin pages for social networks like Facebook, Google+, etc.').
	'</label>'.
'</p>';

echo '<p>'.
	form::checkbox('polyvalence_social_networks_links','1',$polyvalence_SN_links).
	'<label class="classic" for="polyvalence_social_networks_links">'.
		__('Insert links below each post to social networks (Facebook, Google+, twitter). This links behave like officials buttons but without <a href="http://en.wikipedia.org/wiki/Website_visitor_tracking" hreflang="en">tracking</a> and without loading externals scripts.').
	'</label>'.
'</p>';

echo '<p>'.
	form::checkbox('polyvalence_social_networks_buttons','1',$polyvalence_SN_buttons).
	'<label class="classic" for="polyvalence_social_networks_buttons">'.
		__('Insert official buttons below each post to social networks (Facebook, Google+, twitter). Each page will be heavier because of loading of external script.').
	'</label>'.
'</p>';



echo '</div>';

echo '<div class="fieldset"><h3>'.__('Twitter Cards').'</h3>';

echo '<p>'.
	form::checkbox('polyvalence_social_networks_twitter_cards','1',$polyvalence_SN_twitter_cards).
	'<label class="classic" for="polyvalence_social_networks_twitter_cards">'.
		__('Add some Twitter Cards metas if OGP is enabled.').
	'</label>'.
'</p>';

echo '<p class="field"><label for="polyvalence_social_networks_twitter_cards_user">'.__('User ID (@username, if you want to link your user account to this blog):').' '.
	form::field('polyvalence_social_networks_twitter_cards_user',40,255,$polyvalence_SN_twitter_cards_user).'</label>'.'</p>';

echo '<p class="field"><label for="polyvalence_social_networks_twitter_cards_website">'.__('Website ID (@mywebsite, if you have a user account for this blog):').' '.
	form::field('polyvalence_social_networks_twitter_cards_website',40,255,$polyvalence_SN_twitter_cards_website).'</label>'.'</p>';


echo '</div>';



echo '<div class="fieldset"><h3>'.__('Advanced').'</h3>';

echo '<p>'.
	form::checkbox('polyvalence_xhtmlxml','1',$asXHTML).
	'<label class="classic" for="polyvalence_xhtmlxml">'.
		__('Send pages as xhtml5 instead of html5 (pages and content <strong>must</strong> be valid). Doesn\'t work in IE≤8.').
	'</label>'.
'</p>';

echo '<p>'.
	form::checkbox('polyvalence_ie_meta','1',$polyvalence_ie_meta).
	'<label class="classic" for="polyvalence_ie_meta">'.
		__('Don\'t add meta for IE≤9, the web server is configured to send it as <a href="http://msdn.microsoft.com/en-us/library/ff955275%28v=vs.85%29.aspx" hreflang="en">HTTP header</a> (don\'t cheked it if you don\'t know what it is)').
	'</label>'.
'</p>';


echo '</div>';


?>