<?php
if (!defined('DC_RC_PATH')) { return; }

$polyvalence_ns = $core->blog->settings->addNameSpace('polyvalence');

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/public');

if ($core->blog->settings->polyvalence->polyvalence_xhtmlxml)
{
	$core->addBehavior('urlHandlerBeforeGetData',array('sendAsXHTML','urlHandlerBeforeGetData'));
}

$core->addBehavior('coreBlogGetPosts',array('MyHTML5ThemeBehaviors','coreBlogGetPosts'));
$core->tpl->addValue('MyEntryFirstImageURL',array('tplPolyvalenceTpl','MyEntryFirstImageURL'));
$core->tpl->addValue('MyEntryFirstImageNumber',array('tplPolyvalenceTpl','MyEntryFirstImageNumber'));
$core->tpl->addValue('MyEntryFirstImageNumberInit',array('tplPolyvalenceTpl','MyEntryFirstImageNumberInit'));


$core->tpl->addBlock('IfShortlinkPlugin',array('tplPolyvalenceTpl','IfShortlinkPlugin'));
$core->tpl->addBlock('IfNoShortlinkPlugin',array('tplPolyvalenceTpl','IfNoShortlinkPlugin'));
$core->tpl->addBlock('IfSMetaIE',array('tplPolyvalenceTpl','IfSMetaIE'));
$core->tpl->addValue('TwitterEntryTitle',array('tplPolyvalenceTpl','TwitterEntryTitle'));


if ($core->blog->settings->polyvalence->polyvalence_social_networks) {
	$core->tpl->addBlock('IfOgp',array('tplPolyvalenceTpl','IfOgp'));
}
if ($core->blog->settings->polyvalence->polyvalence_social_networks && $core->blog->settings->polyvalence_social_networks_links) {
	$core->tpl->addBlock('IfSnLinks',array('tplPolyvalenceTpl','IfSnLinks'));
}
if ($core->blog->settings->polyvalence->polyvalence_social_networks && $core->blog->settings->polyvalence_social_networks_buttons) {
	$core->tpl->addBlock('IfSnButtons',array('tplPolyvalenceTpl','IfSnButtons'));
}
if ($core->blog->settings->polyvalence->polyvalence_social_networks && $core->blog->settings->polyvalence_social_networks_twitter_cards) {
	$core->tpl->addBlock('IfSnTwitterCards',array('tplPolyvalenceTpl','IfSnTwitterCards'));
	$core->tpl->addValue('TwitterCardsUser',array('tplPolyvalenceTpl','TwitterCardsUser'));
	$core->tpl->addValue('TwitterCardsWebsite',array('tplPolyvalenceTpl','TwitterCardsWebsite'));
}


class sendAsXHTML
{
     public static function urlHandlerBeforeGetData($_ctx)
     {
		if (substr($_ctx->current_tpl,-5) == ".html") {
          $_ctx->content_type = 'application/xhtml+xml';
		}
     }
}

class MyHTML5ThemeBehaviors
{
	public static function coreBlogGetPosts($rs)
	{
		$rs->extend('rsExtHTML5ThemePosts');
	}
}

class rsExtHTML5ThemePosts extends rsExtPostPublic
{
	/**
	Returns trackback RDF information block in HTML comment.
	
	@param	rs	Invisible parameter
	@return	<b>string</b>
	*/
	public static function getTrackbackData($rs)
	{
		return
		"<!--<![CDATA[\n".
		"\n".
		'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"'."\n".
		'  xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n".
		'  xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">'."\n".
		"<rdf:Description\n".
		'  rdf:about="'.$rs->getURL().'"'."\n".
		'  dc:identifier="'.$rs->getURL().'"'."\n".
		'  dc:title="'.htmlspecialchars($rs->post_title,ENT_COMPAT,'UTF-8').'"'."\n".
		'  trackback:ping="'.$rs->getTrackbackLink().'" />'."\n".
		"</rdf:RDF>\n".
		"]]>-->\n";
	}
}

class tplPolyvalenceTpl
{
	public static function IfOgp($attr, $content)
	{
			return
			$content;
	}
	public static function IfSnLinks($attr, $content)
	{
			return
			$content;
	}
	public static function IfSnButtons($attr, $content)
	{
			return
			$content;
	}
	public static function IfSnTwitterCards($attr, $content)
	{
			return
			$content;
	}
	public static function IfShortlinkPlugin($attr, $content)
	{
		global $core;
		return
		'<?php if ($core->plugins->moduleExists(\'shortURL\') && (!isset($core->plugins->getDisabledModules[\'shortURL\'])) && $core->blog->settings->shortURL->shortURLEnabled) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	public static function IfSMetaIE($attr, $content)
	{
		global $core;
		return
		'<?php if (!$core->blog->settings->polyvalence_ie_meta) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	public static function IfNoShortlinkPlugin($attr, $content)
	{
		global $core;
		return
		'<?php if ($core->plugins->moduleExists(\'shortURL\') == false) : ?>'.
		$content.
		'<?php endif; ?>';
	}
	public static function TwitterCardsUser($attr)
	{
		global $core;
		$polyvalence_SN_twitter_cards_user = $core->blog->settings->polyvalence_social_networks_twitter_cards_user;
		return $polyvalence_SN_twitter_cards_user;
	}
	public static function TwitterCardsWebsite($attr)
	{
		global $core;
		$polyvalence_SN_twitter_cards_website = $core->blog->settings->polyvalence_social_networks_twitter_cards_website;
		return $polyvalence_SN_twitter_cards_website;
	}
	public static function TwitterEntryTitle($attr)
	{
	        $f = $GLOBALS['core']->tpl->getFilters($attr);
			return '<?php echo '.sprintf($f,'rawurlencode($_ctx->posts->post_title)').';?>';
	}
	public static function MyEntryFirstImageURL($attr)
	{
		$size = !empty($attr['size']) ? $attr['size'] : '';
		$class = !empty($attr['class']) ? $attr['class'] : '';
		$with_category = !empty($attr['with_category']) ? 'true' : 'false';
		
		return "<?php echo tplPolyvalenceTpl::MyEntryFirstImageURLHelper('".addslashes($size)."',".$with_category.",'".addslashes($class)."'); ?>";
	}
	public static function MyEntryFirstImageNumber($attr)
	{
		
		return "<?php echo \$ImageNumber++; ?>";
	}
	public static function MyEntryFirstImageNumberInit($attr)
	{
		
		return "<?php \$ImageNumber = 0; ?>";
	}
	public static function MyEntryFirstImageURLHelper($attr)
	{
		global $core, $_ctx;
		
		$media = new dcMedia($core);
		$sizes = implode('|',array_keys($media->thumb_sizes)).'|o';
		if (!preg_match('/^'.$sizes.'$/',$size)) {
			$size = 'm';
		}
		$p_url = $core->blog->settings->system->public_url;
		$p_site = preg_replace('#^(.+?//.+?)/(.*)$#','$1',$core->blog->url);
		$p_root = $core->blog->public_path;
		
		$pattern = '(?:'.preg_quote($p_site,'/').')?'.preg_quote($p_url,'/');
		$pattern = sprintf('/<img.+?src="%s(.*?\.(?:jpg|jpeg|gif|png))"[^>]+/msu',$pattern);
		
		$src = '';
		$alt = '';
		
		# We first look in post content
		if ($_ctx->posts)
		{
			$subject = $_ctx->posts->post_excerpt_xhtml.$_ctx->posts->post_content_xhtml;
			if (preg_match_all($pattern,$subject,$m) > 0)
			{
				foreach ($m[1] as $i => $img) {
					if (($src = self::ContentFirstImageLookup($p_root,$img,$size)) !== false) {
						$src = $p_url.(dirname($img) != '/' ? dirname($img) : '').'/'.$src;
						if (preg_match('/alt="([^"]+)"/',$m[0][$i],$malt)) {
							$alt = $malt[1];
						}
						break;
					}
				}
			}
		}
		
		# No src, look in category description if available
		if (!$src && $with_category && $_ctx->categories)
		{
			if (preg_match_all($pattern,$_ctx->categories->cat_desc,$m) > 0)
			{
				foreach ($m[1] as $i => $img) {
					if (($src = self::ContentFirstImageLookup($p_root,$img,$size)) !== false) {
						$src = $p_url.(dirname($img) != '/' ? dirname($img) : '').'/'.$src;
						if (preg_match('/alt="([^"]+)"/',$m[0][$i],$malt)) {
							$alt = $malt[1];
						}
						break;
					}
				}
			};
		}
		if ($src) {
			return $p_site.$src;
		}
	}
	private static function ContentFirstImageLookup($root,$img,$size)
	{		
		global $core;
		# Get base name and extension
		$info = path::info($img);
		$base = $info['base'];
		
		$media = new dcMedia($core);
		$sizes = implode('|',array_keys($media->thumb_sizes));
		if (preg_match('/^\.(.+)_('.$sizes.')$/',$base,$m)) {
			$base = $m[1];
		}
		
		$res = false;
		if ($size != 'o' && file_exists($root.'/'.$info['dirname'].'/.'.$base.'_'.$size.'.jpg'))
		{
			$res = '.'.$base.'_'.$size.'.jpg';
		}
		else
		{
			$f = $root.'/'.$info['dirname'].'/'.$base;
			if (file_exists($f.'.'.$info['extension'])) {
				$res = $base.'.'.$info['extension'];
			} elseif (file_exists($f.'.jpg')) {
				$res = $base.'.jpg';
			} elseif (file_exists($f.'.jpeg')) {
				$res = $base.'.jpeg';
			} elseif (file_exists($f.'.png')) {
				$res = $base.'.png';
			} elseif (file_exists($f.'.gif')) {
				$res = $base.'.gif';
			}
		}
		
		if ($res) {
			return $res;
		}
		return false;
	}

	private static function prout($attr,$content)
	{
		return
		'<?php if ($_ctx->form_error !== null) : ?>'.
		$content.
		'<?php endif; ?>';
	}

}




?>
