<?php
# ***** BEGIN LICENSE BLOCK *****
#
#  	M  I  N  I  M  A  L         G  R  E  Y
#  	Theme by JibHaine (www.jibhaine.fr)
#   Icones by Fam Fam Fam (www.famfamfam.com)
#		Adapted from Black Minimalism theme (http://cinexl.net/blog/?p=63)
#
# ***** END LICENSE BLOCK *****
if (!defined('DC_CONTEXT_ADMIN')) { return; }global $core;

//PARAMS

# Translations
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');

# Default values
$default_color = 'green';
$default_sidebar = false;

# Settings
$my_color = $core->blog->settings->themes->minimalgrey_color;
$my_sidebar = $core->blog->settings->themes->minimalgrey_sidebar;

# Color scheme
$minimalgrey_color_combo = array(
	__('green') => 'green',
	__('blue') => 'blue',
	__('orange') => 'orange',
	__('pink') => 'pink',
	__('purple') => 'purple',
	__('red') => 'red'
);

// POST ACTIONS

if (!empty($_POST))
{
	try
	{
		$core->blog->settings->addNamespace('themes');

		# Color scheme
		if (!empty($_POST['minimalgrey_color']) && in_array($_POST['minimalgrey_color'],$minimalgrey_color_combo))
		{
			$my_color = $_POST['minimalgrey_color'];


		} elseif (empty($_POST['minimalgrey_color']))
		{
			$my_color = $default_color;

		}
		$core->blog->settings->themes->put('minimalgrey_color',$my_color,'string','Color display',true);

		# Sidebar
		if (!empty($_POST['minimalgrey_sidebar']))
		{
			$my_sidebar = $_POST['minimalgrey_sidebar'];

		} elseif (empty($_POST['minimalgrey_sidebar']))
		{
			$my_sidebar = $default_sidebar;

		}
		$core->blog->settings->themes->put('minimalgrey_sidebar',$my_sidebar,'boolean', 'Display sidebar in post context',true);

		// Blog refresh
		$core->blog->triggerBlog();

		// Template cache reset
		$core->emptyTemplatesCache();

		dcPage::success(__('Theme configuration has been successfully updated.'),true,true);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

// DISPLAY

# Color scheme
echo
'<div class="fieldset"><h4>'.__('Customizations').'</h4>'.
'<p class="field"><label>'.__('Color display:').'</label>'.
form::combo('minimalgrey_color',$minimalgrey_color_combo,$my_color).
'</p>';

# Sidebar
echo
'<p>'.
	form::checkbox('minimalgrey_sidebar',1,$my_sidebar).
	'<label class="classic" for="minimalgrey_sidebar">'.
		__('Display sidebar in post context').
	'</label>'.
'</p>'.
'</div>';