<?php
# ***** BEGIN LICENSE BLOCK *****
#
# Sober
# Theme by Pyeb
# Contributor : Pierre Van Glabeke
# License: public domain
#
# ***** END LICENSE BLOCK *****

# Version originale de dsls : http://www.morefnu.org/

if (!defined('DC_CONTEXT_ADMIN')) exit;

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');
require dirname(__FILE__).'/lib/class.sober.config.php';

$config = new soberConfig($core);

$images = $config->getThumbImages();
$current_custom_theme = $core->blog->settings->themes->sober_custom;
if ($current_custom_theme == null) {
	$current_custom_theme = 'default';
}
if (!empty($_POST))
{
	$current_custom_theme = $_POST['sober_custom'];
	$core->blog->settings->addNamespace('themes');
	$core->blog->settings->themes->put('sober_custom',$current_custom_theme,'string');
	$core->blog->triggerBlog();
	
	dcPage::success(__('Theme configuration has been successfully updated.'));
}
echo '<script type="text/javascript" src="js/_blog_theme.js"></script>';

# Options display
echo '<div class="fieldset" style="border:none;"><h4>'.__('Preferences').'</h4>';
$nb_img = count($images);
$nb_img_by_col = ($nb_img-$nb_img%3)/3;
echo '<div id="imgheaders">';
$count=0;
echo '<div class="three-cols"><div class="col"><ul style="list-style:none;">';
echo '<li><label for="default">'.form::radio(array('sober_custom','default'),'default',$current_custom_theme=='default').__('Default theme').'</label><br />'.'<img src="blog_theme.php?shot=sober&amp;src=img/classic.jpg" alt="classic" style="margin:1em 0;" />'.'</li>';
foreach ($images as $ref => $image) {
	if ($count != 0 && $count%$nb_img_by_col==0)
		echo '</ul></div><div class="col"><ul style="list-style:none;">';
	echo '<li><label for="'.$ref.'">'.form::radio(array('sober_custom',$ref),$ref,$current_custom_theme==$ref).$ref.'</label><br />'.'<img src="'.$image['thumb'].'" alt="'.$ref.'" style="margin:1em 0;" /></li>';
	$count++;
}
echo '</ul></div></div></div>';
echo '</div>';