<?php
# ***** BEGIN LICENSE BLOCK *****
#
#  	Grid Seven
#  	Theme by David Yim
#   Contributor : Pierre Van Glabeke
#   License : public domain
#
# ***** END LICENSE BLOCK *****
if (!defined('DC_CONTEXT_ADMIN')) { return; }

global $core;

//PARAMS

# Translations
l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');

# Default values
$default_menu = 'catlevel1';

# Settings
$my_menu = $core->blog->settings->themes->gridseven_menu;

# Width type
$gridseven_menu_combo = array(
	__('categories, level 1') => 'catlevel1',
	__('simpleMenu') => 'simplemenu'
);

// POST ACTIONS

if (!empty($_POST))
{
	try
	{
		$core->blog->settings->addNamespace('themes');

		# Menu
		if (!empty($_POST['gridseven_menu']) && in_array($_POST['gridseven_menu'],$gridseven_menu_combo))
		{
			$my_menu = $_POST['gridseven_menu'];

		} elseif (empty($_POST['gridseven_menu']))
		{
			$my_menu = $default_menu;

		}
		$core->blog->settings->themes->put('gridseven_menu',$my_menu,'string','Menu to display',true);

		// Blog refresh
		$core->blog->triggerBlog();

		// Template cache reset
		$core->emptyTemplatesCache();

		dcPage::success(__('Theme configuration has been successfully updated.'),true,true);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

// DISPLAY

# Menu
echo
'<div class="fieldset"><h4>'.__('Menu').'</h4>'.
'<p class="field"><label>'.__('Display:').'</label>'.
form::combo('gridseven_menu',$gridseven_menu_combo,$my_menu).
'</p>'.
'</div>';