<?php
# ***** BEGIN LICENSE BLOCK *****
#
#  	Grid Seven
#  	Theme by David Yim
#   Contributor : Pierre Van Glabeke
#   License : public domain
#
# ***** END LICENSE BLOCK *****

# NOTES IMPORTANTES : l'introduction des gravatars sont l'oeuvre de Nicolas Perriault   
# URI de l'auteur : http://prendreuncafe.com/
# URI de l'article associe : http://prendreuncafe.com/blog/post/2006/09/21/Dotclear2-et-les-gravatars

if (!defined('DC_RC_PATH')) { return; }

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/public');

$core->addBehavior('publicHeadContent','gridseven_publicHeadContent');

function gridseven_publicHeadContent($core)
{
	$style = $core->blog->settings->themes->gridseven_menu;
	if (!preg_match('/^catlevel1|simplemenu$/',$style)) {
		$style = 'catlevel1';
	}

	$url = $core->blog->settings->system->themes_url.'/'.$core->blog->settings->system->theme;
	echo '<link rel="stylesheet" type="text/css" media="screen" href="'.$url."/".$style.".css\" />\n";
}

$core->tpl->addValue('gravatar', array('gravatar', 'tplGravatar'));

class gravatar {

  const
    URLBASE = 'http://www.gravatar.com/avatar.php?gravatar_id=%s&amp;default=%s&amp;size=%d',
    HTMLTAG = '<img src="%s" class="%s" alt="%s" />',
    DEFAULT_SIZE = '50',
    DEFAULT_CLASS = 'gravatar_img',
    DEFAULT_ALT = 'Gravatar de %s';

  public static function tplGravatar($attr)
  {
    $md5mail = '\'.md5(strtolower($_ctx->comments->getEmail(false))).\'';
    $size    = array_key_exists('size',   $attr) ? $attr['size']   : self::DEFAULT_SIZE;
    $class   = array_key_exists('class',  $attr) ? $attr['class']  : self::DEFAULT_CLASS;
    $alttxt  = array_key_exists('alt',    $attr) ? $attr['alt']    : self::DEFAULT_ALT;
    $altimg  = array_key_exists('altimg', $attr) ? $attr['altimg'] : '';
    $gurl    = sprintf(self::URLBASE,
                       $md5mail, urlencode($altimg), $size);
    $gtag    = sprintf(self::HTMLTAG,
                       $gurl, $class, preg_match("/%s/i", $alttxt) ?
                                      sprintf($alttxt, '\'.$_ctx->comments->comment_author.\'') : $alttxt);
    return '<?php echo \'' . $gtag . '\'; ?>';
  }

}