# Origine, un thème Dotclear

![Capture d’écran](https://github.com/te2dy/origine/blob/master/screenshot-2x.jpg)

## Présentation

Que vous soyez journaliste, écrivain ou simple blogueur, Origine est un thème idéal pour mettre en valeur vos écrits.

Il a été spécialement conçu pour garantir une **excellente lisibilité** à vos textes tout en réduisant, grâce à son apparence **minimaliste**, les éléments de distraction qui pourraient perturber leur lecture.

Flexible, il prend en compte les préférences de vos lecteurs. Par exemple, la taille de ses textes n’est pas arbitraire ; elle correspond à la taille des polices définie dans les réglages du navigateur.

## Caractéristiques

- Grande lisibilité.
- Utilisation des polices du système pour réduire le temps de chargement des pages.
- Adaptation à toutes les tailles d’écran, des ordinateurs aux téléphones.
- Optimisé pour l’impression.
- Schéma de couleurs clair ou sombre en fonction du thème du système.
- Prise en charge des fonctions _Simple Menu_, _Widgets_ et _[Markdown syntax](https://plugins.dotaddict.org/dc2/details/formatting-markdown)_ de Dotclear.
- Prise en compte des paramètres d’accessibilité du système (contrastes élevés, suppression des animations).
- Personnalisations avancées avec l’extension [origineConfig](https://github.com/te2dy/origineConfig).
- jQuery n’est pas nécessaire.

## Démonstration

Pour voir Origine en conditions réelles, visitez le **[blog de démonstration sur DotAddict](https://themes.dotaddict.org/demo-dc2/?theme=origine)**.

## Téléchargement

**[Télécharger la dernière version d’Origine sur GitHub](https://github.com/te2dy/origine/releases/latest)**

**[Télécharger la dernière version d’Origine sur DotAddict](https://themes.dotaddict.org/galerie-dc2/details/origine)**

## Installation

Dans l’administration de votre blog, rendez-vous dans _Apparence du blog_ et cliquez :
- soit sur l’onglet _Ajouter des thèmes_ pour télécharger et installer Origine directement depuis l’interface d’administration ;
- soit sur l’onglet _Installer ou mettre à jour manuellement_ pour téléverser et installer une version d’Origine préalablement téléchargée.

## Personnalisation

Origine peut-être personnalisé avec l’extension **origineConfig** : modification du schéma de couleurs, de la police d’écriture, ou encore de la taille et de l’alignement des textes.

Rendez-vous sur [la page dédiée à origineConfig](https://github.com/te2dy/origineConfig).

## Contribuer, suggérer, signaler

N’hésitez pas à [contribuer](https://github.com/te2dy/origine/pulls) à ce projet, à [suggérer](https://github.com/te2dy/origine/issues) des nouvelles fonctionnalités ou à [signaler](https://github.com/te2dy/origine/issues) des problèmes directement depuis GitHub. Vous pouvez aussi [me contacter par courriel](mailto:zozxebpyr@mozmail.com).

## Licence

[Licence publique générale GNU version 3.0](https://github.com/te2dy/origine/blob/master/LICENSE)