<?php

namespace themes\aspect;

if (!defined('DC_RC_PATH')) { return; }

\l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/public');

$core->tpl->addBlock('EntryIfContentIsCut',array(__NAMESPACE__.'\tplAspectTheme','EntryIfContentIsCut'));
$core->tpl->addBlock('AspectLogo',array(__NAMESPACE__.'\tplAspectTheme','AspectLogo'));
$core->tpl->addBlock('AspectStyle',array(__NAMESPACE__.'\tplAspectTheme','AspectStyle'));

class tplAspectTheme
{
    // À partir du thème Ductile - http://ductile.dotaddict.org
    public static function EntryIfContentIsCut($attr,$content)
    {
        global $core;

        if (empty($attr['cut_string']) || !empty($attr['full'])) {
            return '';
        }

        $urls = '0';
        if (!empty($attr['absolute_urls'])) {
            $urls = '1';
        }

        $short = $core->tpl->getFilters($attr);
        $cut = $attr['cut_string'];
        $attr['cut_string'] = 0;
        $full = $core->tpl->getFilters($attr);
        $attr['cut_string'] = $cut;

        return '<?php if (strlen('.sprintf($full,'$_ctx->posts->getContent('.$urls.')').') > '.
            'strlen('.sprintf($short,'$_ctx->posts->getContent('.$urls.')').')) : ?>'.
            $content.
            '<?php endif; ?>';
    }

    public static function AspectLogo($attr,$content)
    {
        global $core;

        $blogURL = $core->blog->url;
        $logo = $attr['logo'];

        if (empty($logo)) {
            return '';
        } elseif (filter_var($logo, FILTER_VALIDATE_URL) !== false) {
            return '<a href="<?php echo "'.$blogURL.'"; ?>" itemprop="url"><img src="<?php echo "'.$logo.'"; ?>" id="site-logo" itemprop="logo"></a>';
        }
    }

    public static function AspectStyle($attr, $content)
    {
        $style = $attr['style'];
        if ($style == '2') {
            return '
                <style>
                    .post-content > p {
                        margin: 0;
                        text-indent: 1.5em;
                    }
                    .post-content p iframe {
                        margin-left: -1.5em;
                    }
                    .comment-content p {
                        margin: 0;
                    }
                </style>';
        }
    }
}