<?php
/**
 * @brief editorial, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @copyright Philippe aka amalgame
 * @copyright GPL-2.0-only
 */


if (!defined('DC_CONTEXT_ADMIN')) {return;}

l10n::set(dirname(__FILE__) . '/locales/' . $_lang . '/admin');

$standalone_config = (boolean) $core->themes->moduleInfo($core->blog->settings->system->theme, 'standalone_config');

$editorial_user = $core->blog->settings->themes->get($core->blog->settings->system->theme . '_featured');
$editorial_user = @unserialize($editorial_user);

if (!is_array($editorial_user)) 
{
    $editorial_user = [];
    $editorial_user['static_home_url'] = '';
}

// Load contextual help
if (file_exists(dirname(__FILE__) . '/locales/' . $_lang . '/resources.php')) {
    require dirname(__FILE__) . '/locales/' . $_lang . '/resources.php';
}

if (!empty($_POST)) {
    try
    {
        # HTML
        $editorial_user['static_home_url'] = $_POST['static_home_url'];
        
        $core->blog->settings->addNamespace('themes');
        $core->blog->settings->themes->put($core->blog->settings->system->theme . '_featured', serialize($editorial_user));

        // Blog refresh
        $core->blog->triggerBlog();

        // Template cache reset
        $core->emptyTemplatesCache();

        dcPage::success(__('Theme configuration upgraded.'), true, true);
    } catch (Exception $e) {
        $core->error->add($e->getMessage());
    }
}

// Legacy mode
if (!$standalone_config) {
    echo '</form>';
}

echo '<form id="theme_config" action="' . $core->adminurl->get('admin.blog.theme', ['conf' => '1']) .
    '" method="post" enctype="multipart/form-data">';

echo '<h4 class="pretty-title">' . __('Blog\'s featured publication') . '</h4>';

echo '<p><label for="static_home_url" class="classic">' . __('Entry URL:') . '</label> ' .
    form::field('static_home_url', 30, 255, html::escapeHTML($editorial_user['static_home_url'])) .
    ' <button type="button" id="featured_home_url_selector">' . __('Choose an entry') . '</button>' .
    '</p>' .
    '<p class="form-note info maximal">' . __('Leave empty to use the default presentation (latest post)') . '</p> ';

echo '<p class="clear"><input type="submit" value="' . __('Save') . '" />' . $core->formNonce() . '</p>';
echo '</form>';


dcPage::helpBlock('editorial');

// Legacy mode
if (!$standalone_config) {
    echo '<form style="display:none">';
}
