<?php
/**
 * @brief Editorial, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @copyright Philippe aka amalgame
 * @copyright GPL-2.0-only
 */

if (!defined('DC_RC_PATH')) { return; }

l10n::set(dirname(__FILE__).'/locales/'.$_lang.'/main');

$core->tpl->addBlock('editorialDefaultIf', ['featuredPostTpl', 'editorialDefaultIf']);
$core->tpl->addBlock('editorialFeaturedIf', ['featuredPostTpl', 'editorialFeaturedIf']);

$core->addBehavior('templateBeforeBlock',array('behaviorsFeaturedPost','templateBeforeBlock'));

class featuredPostTpl
{
    public static function editorialDefaultIf($attr, $content)
    {
        global $core;

        $editorial_user = $core->blog->settings->themes->get($core->blog->settings->system->theme . '_featured');
        $editorial_user = @unserialize($editorial_user);

        $featuredPostURL = $editorial_user['static_home_url'];

        if ($featuredPostURL =='') {
            return $content;
            
        } else {
            return;
        }
    }

    public static function editorialFeaturedIf($attr, $content)
    {
        global $core;

        $editorial_user = $core->blog->settings->themes->get($core->blog->settings->system->theme . '_featured');
        $editorial_user = @unserialize($editorial_user);

        $featuredPostURL = $editorial_user['static_home_url'];

        if ($featuredPostURL !=='') {
            return $content;
            
        } else {
            return;
        }
    }
}

class behaviorsFeaturedPost
{
    public static function templateBeforeBlock($core,$b,$attr)
    {
        global $core;
        
        $editorial_user = $core->blog->settings->themes->get($core->blog->settings->system->theme . '_featured');
        $editorial_user = @unserialize($editorial_user);

        $featuredPostURL = $editorial_user['static_home_url'];

        if ($b == 'Entries' && isset($attr['featured_url']) && $attr['featured_url'] == 1)
        {
            return
            "<?php\n" .
            "if (!isset(\$params)) { \$params = []; }\n" .
            "if (!isset(\$params['sql'])) { \$params['sql'] = ''; }\n" .
            "\$params['sql'] .= \"AND P.post_url = '" . urldecode($featuredPostURL) . "' \";\n" .
                "?>\n";
        } elseif ($b == 'Entries' && isset($attr['featured_url']) && $attr['featured_url'] == 0)
        {
            return
            "<?php\n" .
            "if (!isset(\$params)) { \$params = []; }\n" .
            "if (!isset(\$params['sql'])) { \$params['sql'] = ''; }\n" .
            "\$params['sql'] .= \"AND P.post_url != '" . urldecode($featuredPostURL) . "' \";\n" .
                "?>\n";
        }
    }
}
