<?php
/**
 * @brief Freelancer, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @author Philippe aka amalgame and contributors
 * @copyright GPL-2.0
 */

if (!defined('DC_CONTEXT_ADMIN')) {
    return;
}

l10n::set(dirname(__FILE__) . '/locales/' . $_lang . '/admin');

$standalone_config = (bool) $core->themes->moduleInfo($core->blog->settings->system->theme, 'standalone_config');

if (preg_match('#^http(s)?://#', $core->blog->settings->system->themes_url)) {
    $theme_url = \http::concatURL($core->blog->settings->system->themes_url, '/' . $core->blog->settings->system->theme);
} else {
    $theme_url = \http::concatURL($core->blog->url, $core->blog->settings->system->themes_url . '/' . $core->blog->settings->system->theme);
}
$freelancer_default_image_url = $theme_url . '/img/home.png';

$s = $GLOBALS['core']->blog->settings->themes->get($GLOBALS['core']->blog->settings->system->theme . '_style');
$s = $s ? (unserialize($s) ?: []) : [];

if (!is_array($s)) {
    $s = [];
}
if (!isset($s['freelancer_user_image']) || empty($s['freelancer_user_image'])) {
    $s['freelancer_user_image'] = $freelancer_default_image_url;
}

// Load contextual help
if (file_exists(dirname(__FILE__) . '/locales/' . $_lang . '/resources.php')) {
    require dirname(__FILE__) . '/locales/' . $_lang . '/resources.php';
}

if (!empty($_POST)) {
    try {
        // HTML
        if (!empty($_POST['freelancer_user_image'])) {
            $s['freelancer_user_image'] = $_POST['freelancer_user_image'];
        } else {
            $s['freelancer_user_image'] = $freelancer_default_image_url;
        }

        $core->blog->settings->addNamespace('themes');
        $core->blog->settings->themes->put($core->blog->settings->system->theme . '_style', serialize($s));

        // Blog refresh
        $core->blog->triggerBlog();

        // Template cache reset
        $core->emptyTemplatesCache();

        dcPage::success(__('Theme configuration upgraded.'), true, true);
    } catch (Exception $e) {
        $core->error->add($e->getMessage());
    }
}

// Legacy mode
if (!$standalone_config) {
    echo '</form>';
}

echo '<form id="theme_config" action="' . $core->adminurl->get('admin.blog.theme', ['conf' => '1']) .
    '" method="post" enctype="multipart/form-data">';

echo '<h4 class="pretty-title">' . __('Profile image') . '</h4>';

echo '<div class="box theme">';

echo '<p> ' .
'<img id="freelancer_user_image_src" alt="' . __('Thumbnail') . '" src="' . $s['freelancer_user_image'] . '" class="img-profile" />' .
 '</p>';

echo '<p class="freelancer-buttons"><button type="button" id="freelancer_user_image_selector">' . __('Change') . '</button>' .
'<button class="delete" type="button" id="freelancer_user_image_reset">' . __('Reset') . '</button>' .
'</p>' ;

echo '<p class="hidden-if-js">' . form::field('freelancer_user_image', 30, 255, $s['freelancer_user_image']) . '</p>';

echo '</div>';

echo '<p class="clear"><input type="submit" value="' . __('Save') . '" />' . $core->formNonce() . '</p>';
echo form::hidden(['theme-url'], $theme_url);
echo '</form>';

dcPage::helpBlock('freelancer');

// Legacy mode
if (!$standalone_config) {
    echo '<form style="display:none">';
}
