<?php
/**
 * @brief Freelancer, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @author Philippe aka amalgame and contributors
 * @copyright GPL-2.0
 */

namespace Dotclear\Theme\Freelancer;

use dcCore;
use dcNsProcess;
use http;

class Prepend extends dcNsProcess
{
    public static function init(): bool
    {
        self::$init = defined('DC_CONTEXT_ADMIN');

        return self::$init;
    }

    public static function process(): bool
    {
        if (!self::$init) {
            return false;
        }

        dcCore::app()->addBehavior('adminPageHTMLHead', function () {
            if (dcCore::app()->blog->settings->system->theme !== basename(dirname(__DIR__))) {
                return;
            }

            if (preg_match('#^http(s)?://#', dcCore::app()->blog->settings->system->themes_url)) {
                $theme_url = http::concatURL(dcCore::app()->blog->settings->system->themes_url, '/' . dcCore::app()->blog->settings->system->theme);
            } else {
                $theme_url = http::concatURL(dcCore::app()->blog->url, dcCore::app()->blog->settings->system->themes_url . '/' . dcCore::app()->blog->settings->system->theme);
            }

            echo '<script src="' . $theme_url . '/js/admin.js' . '"></script>' . "\n" .
            '<script src="' . $theme_url . '/js/popup_media.js' . '"></script>' . "\n" .
            '<link rel="stylesheet" media="screen" href="' . $theme_url . '/css/admin.css' . '" />' . "\n";
        });

        return true;
    }
}
