<?php
/**
 * @brief Freelancer, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @author Start Bootstrap and Philippe aka amalgame
 *
 * @copyright Philippe Hénaff philippe@dissitou.org
 * @copyright GPL-2.0
 */
declare(strict_types=1);

namespace Dotclear\Theme\freelancer;

use dcCore;
use Dotclear\Core\Process;
use Dotclear\Core\Backend\Page;
use Dotclear\Core\Backend\Notices;
use Exception;
use form;

class Config extends Process
{
    public static function init(): bool
    {
        // limit to backend permissions
        if (!self::status(My::checkContext(My::CONFIG))) {
            return false;
        }

        My::l10n('admin');

        dcCore::app()->admin->standalone_config = (bool) dcCore::app()->themes->moduleInfo(dcCore::app()->blog->settings->system->theme, 'standalone_config');

        dcCore::app()->admin->freelancer_default_image_url = My::fileURL('/img/home.png');

        $style = dcCore::app()->blog->settings->themes->get(dcCore::app()->blog->settings->system->theme . '_style');
        $style = $style ? (unserialize($style) ?: []) : [];

        if (!is_array($style)) {
            $style = [];
        }

        if (!isset($style['freelancer_user_image']) || empty($style['freelancer_user_image'])) {
            $style['freelancer_user_image'] = dcCore::app()->admin->freelancer_default_image_url;
        }

        dcCore::app()->admin->style     = $style;
        dcCore::app()->admin->theme_url = My::fileURL('');

        return self::status();
    }

    /**
     * Processes the request(s).
     */
    public static function process(): bool
    {
        if (!self::status()) {
            return false;
        }

        if (!empty($_POST)) {
            try {
                // HTML
                $style = [];
                if (!empty($_POST['freelancer_user_image'])) {
                    $style['freelancer_user_image'] = $_POST['freelancer_user_image'];
                } else {
                    $style['freelancer_user_image'] = dcCore::app()->admin->freelancer_default_image_url;
                }

                dcCore::app()->admin->style = $style;

                dcCore::app()->blog->settings->themes->put(dcCore::app()->blog->settings->system->theme . '_style', serialize(dcCore::app()->admin->style));

                // Blog refresh
                dcCore::app()->blog->triggerBlog();

                // Template cache reset
                dcCore::app()->emptyTemplatesCache();

                Notices::success(__('Theme configuration upgraded.'), true, true);
            } catch (Exception $e) {
                dcCore::app()->error->add($e->getMessage());
            }
        }

        return true;
    }

    /**
     * Renders the page.
     */
    public static function render(): void
    {
        if (!self::status()) {
            return;
        }

        if (!dcCore::app()->admin->standalone_config) {
            echo '</form>';
        }

        echo '<form id="theme_config" action="' . dcCore::app()->adminurl->get('admin.blog.theme', ['conf' => '1']) .
        '" method="post" enctype="multipart/form-data">';

        echo '<h4 class="pretty-title">' . __('Profile image') . '</h4>';

        echo '<div class="box theme">';

        echo '<p> ' .
        '<img id="freelancer_user_image_src" alt="' . __('Thumbnail') . '" src="' . dcCore::app()->admin->style['freelancer_user_image'] . '" class="img-profile" />' .
         '</p>';

        echo '<p class="freelancer-buttons"><button type="button" id="freelancer_user_image_selector">' . __('Change') . '</button>' .
        '<button class="delete" type="button" id="freelancer_user_image_reset">' . __('Reset') . '</button>' .
        '</p>' ;

        echo '<p class="hidden-if-js">' . form::field('freelancer_user_image', 30, 255, dcCore::app()->admin->style['freelancer_user_image']) . '</p>';

        echo '</div>';

        echo '<p class="clear"><input type="submit" value="' . __('Save') . '" />' . dcCore::app()->formNonce() . '</p>';
        echo form::hidden(['theme-url'], dcCore::app()->admin->theme_url);
        echo '</form>';

        Page::helpBlock('freelancer');

        // Legacy mode
        if (!dcCore::app()->admin->standalone_config) {
            echo '<form style="display:none">';
        }
    }
}
