<?php
/**
 * Odyssey, a simple and customizable Dotclear theme.
 *
 * @author    Teddy <zozxebpyr@mozmail.com>
 * @copyright 2022-2025 Teddy
 * @license   GPL-3 (https://www.gnu.org/licenses/gpl-3.0.en.html)
 *
 * @link https://dotclear.watch/Billet/Le-plugin-Uninstaller
 */

namespace Dotclear\Theme\odyssey;

use Dotclear\App;
use Dotclear\Core\Process;
use Dotclear\Helper\File\Path;
use Dotclear\Helper\Html\Form\Checkbox;
use Dotclear\Helper\Html\Form\Label;
use Dotclear\Helper\Html\Form\Para;
use Dotclear\Plugin\Uninstaller\Uninstaller;

class Uninstall extends Process
{
    public static function init(): bool
    {
        My::l10n('admin');

        return self::status(My::checkContext(My::UNINSTALL));
    }

    public static function process(): bool
    {
        if (!self::status() || !App::themes()->moduleExists('odyssey')) {
            return false;
        }

        Uninstaller::instance()
            ->addUserAction(
                'settings',
                'delete_all',
                My::id(),
                true
            )
            ->addUserAction(
                'themes',
                'delete',
                My::id(),
                true
            )
        ;

        if (isset($_POST['delete_odyssey_public_folder'])) {
            $dir_path = Path::real(App::blog()->publicPath() . '/' . My::id());

            self::_deleteDirectory($dir_path);
        }

        return true;
    }

    /**
     * Adds a checkbox to the uninstaller form.
     *
     * @return void The checkbox.
     */
    public static function render(): void
    {
        if (!self::status()) {
            return;
        }

        echo (new Para())
            ->items([
                (new Checkbox('delete_odyssey_public_folder', true))
                    ->value(1),
                (new Label(__('uninstall-checkbox-label'), Label::OUTSIDE_LABEL_AFTER))
                    ->for('delete_odyssey_public_folder')
                    ->class('classic'),
            ])
            ->render();
    }

    /**
     * Creates a method to delete odyssey files that have been put
     * in the public folder of Dotclear
     *
     * @param string The path of the directory
     *
     * @return void Remove the folder and all its contents.
     */
    private static function _deleteDirectory(string $dir_path): void
    {
        if (is_dir($dir_path)) {
            $files = scandir($dir_path);

            foreach ($files as $item) {
                if ($item !== '.' && $item !== '..') {
                    $file_path = $dir_path . '/' . $item;

                    if (is_dir($file_path)) {
                        self::_deleteDirectory($file_path);
                    } else {
                        unlink($file_path);
                    }
                }
            }

            rmdir($dir_path);
        }
    }
}
